"""
Przykład z podrozdziału "Programowanie asynchroniczne"
pokazujący, jak używać obiektów future i wielowątkowości/wieloprocesowości
w celu zastosowania bibliotek nieasynchronicznych w aplikacjach
bazujących na module asyncio.

"""
import asyncio
import time

import requests

SYMBOLS = ("USD", "EUR", "PLN", "NOK", "CZK")
BASES = ("USD", "EUR", "PLN", "NOK", "CZK")

THREAD_POOL_SIZE = 4


async def fetch_rates(base):
    loop = asyncio.get_event_loop()
    response = await loop.run_in_executor(
        None, requests.get, f"https://api.vatcomply.com/rates?base={base}"
    )
    response.raise_for_status()
    rates = response.json()["rates"]
    # Uwaga - kurs wymiany waluty z nią samą wynosi 1:1.
    rates[base] = 1.0
    return base, rates


def present_result(base, rates):
    rates_line = ", ".join([f"{rates[symbol]:7.03} {symbol}" for symbol in SYMBOLS])
    print(f"1 {base} = {rates_line}")


async def main():
    for result in await asyncio.gather(*[fetch_rates(base) for base in BASES]):
        present_result(*result)


if __name__ == "__main__":
    started = time.time()
    loop = asyncio.get_event_loop()
    loop.run_until_complete(main())
    elapsed = time.time() - started

    print()
    print("Czas wykonywania: {:.2f}s".format(elapsed))
